//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk](../index.md)/[BotStacksChatPlatform](index.md)

# BotStacksChatPlatform

[common]\
expect class [BotStacksChatPlatform](index.md) : [BotStacksChat](../-bot-stacks-chat/index.md)

[android]\
@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)

actual class [BotStacksChatPlatform](index.md) : [BotStacksChat](../-bot-stacks-chat/index.md)

Main Android entry point for the BotStacks SDK.

Setup/initialization is done via [setup](setup.md), while login and log out are done via [login](login.md) and [BotStacksChat.logout](../-bot-stacks-chat/-companion/logout.md), respectively.

Registering an FCM token for push notification support is done via [BotStacksChat.registerFCMToken](../-bot-stacks-chat/-companion/register-f-c-m-token.md).

[ios]\
@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)

actual class [BotStacksChatPlatform](index.md) : BotStacksChat

Main iOS entry point for the BotStacks SDK.

Setup/initialization is done via [setup](setup.md), while login and log out are done via [login](login.md) and BotStacksChat.logout, respectively.

Registering an FCM token for push notification support is done via BotStacksChat.registerFCMToken.

## Constructors

| | |
|---|---|
| [BotStacksChatPlatform](-bot-stacks-chat-platform.md) | [android, ios]<br>constructor()<br>[common]<br>expect constructor() |

## Properties

| Name | Summary |
|---|---|
| [apiKey](api-key.md) | [common, android, ios]<br>[common]<br>expect val [apiKey](api-key.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[android, ios]<br>actual val [apiKey](api-key.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [appIdentifier](app-identifier.md) | [common, android, ios]<br>[common]<br>expect val [appIdentifier](app-identifier.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[android, ios]<br>actual val [appIdentifier](app-identifier.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [prefs](prefs.md) | [ios]<br>open val [prefs](prefs.md): Settings |
| [scope](scope.md) | [common, android, ios]<br>[common]<br>expect val [scope](scope.md): CoroutineScope<br>[android, ios]<br>actual val [scope](scope.md): CoroutineScope |

## Functions

| Name | Summary |
|---|---|
| [load](load.md) | [common, ios]<br>[common]<br>expect suspend fun [load](load.md)()<br>[ios]<br>actual suspend fun [load](load.md)()<br>[android]<br>actual suspend fun [load](load.md)()<br>Load trigger for loading user data. A logged in check is done during this phase to allow routing to login if needed. |
| [login](login.md) | [common, android, ios]<br>[common]<br>expect suspend fun [login](login.md)(userId: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), username: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), displayName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, picture: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null)<br>[android, ios]<br>actual suspend fun [login](login.md)(userId: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), username: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), displayName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, picture: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)<br>login to BotStacks Backend |
| [setup](setup.md) | [ios]<br>fun [setup](setup.md)(apiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>fun [setup](setup.md)(apiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), giphyApiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, googleMapsApiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)<br>fun [setup](setup.md)(apiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), giphyApiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, googleMapsApiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, delayLoad: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>[android]<br>fun [setup](setup.md)(context: [Context](https://developer.android.com/reference/kotlin/android/content/Context.html), apiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), giphyApiKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, delayLoad: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>setup app instance for interfacing with the BotStacksSDK. |
